/*****************************************************************************
 *
 * Copyright (c) ComponentOne, LLC.
 * Portions Copyright (c) 1999, KL GROUP INC.
 * http://www.componentone.com
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of ComponentOne not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * ComponentOne.
 *
 * COMPONENTONE MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. COMPONENTONE SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY USERS AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 *****************************************************************************/

#define STRICT
#include <windows.h>
#include <olch2d.h>
#include "plot1.h"
#include "resource.h"

static HXRT2D hChart;

LRESULT WINAPI
WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static HWND hwndChart;
	static XrtDataHandle my_data;

	switch (msg) {

	case WM_COMMAND:
		/* handle commands */
		switch(LOWORD(wParam)) {

		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;

		case IDM_ABOUTDEMO:
		case IDMHELP:
			WinHelp(hWnd, "OLCH8DMO.HLP", HELP_CONTEXT, 39);
			break;

		case IDM_ABOUTC1CHART:
			WinHelp(hWnd, "OLCH8DMO.HLP", HELP_CONTEXT, 19);
			break;

		default:
			break;
		}
		break;

   	case XRTN_PALETTECHANGED:
        SendMessage(XrtGetWindow(hChart), WM_QUERYNEWPALETTE, 0, 0);
        break;

    case WM_QUERYNEWPALETTE:
    case WM_PALETTECHANGED:
        SendMessage(XrtGetWindow(hChart), msg, wParam, lParam);
        break;
	
	case WM_INITDIALOG:
		/* Get chart handle from dialog resource */
		hwndChart = GetDlgItem(hWnd, IDCHART);
        hChart = XrtCreate();
        XrtAttachWindow(hChart, hwndChart);

		/* Allocate and load data, set it to chart's Data property */
		my_data = XrtDataCreateFromFile("mm63.dat", NULL);
		XrtSetValues(hChart, XRT_DATA, my_data, NULL);
		break;

	case WM_CLOSE:
		XrtDataDestroy(my_data);
		DestroyWindow(hWnd);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	default:
		return FALSE;
	}
	return TRUE;
}

int PASCAL
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	static char szAppName[] = "plot1";
	HWND 		hWnd;
	MSG 		msg;
	WNDCLASS 	wc;
	DLGPROC 	dlgprc;
	HACCEL      hAccel;

	if (!hPrevInstance) {
		wc.style		    = CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc	    = WndProc;
		wc.cbClsExtra	    = 0;
		wc.cbWndExtra	    = 0;
		wc.hInstance	    = hInstance;
		wc.hIcon 		    = LoadIcon (hInstance, "olch2dicon");
		wc.hCursor		    = LoadCursor (NULL, IDC_ARROW);
		wc.hbrBackground	= GetStockObject (WHITE_BRUSH);
		wc.lpszMenuName		= NULL;
		wc.lpszClassName 	= szAppName;

		if (!RegisterClass(&wc)) return FALSE;
	}

	hAccel = LoadAccelerators(hInstance, "Plot1Accelerators");
	
	dlgprc = (DLGPROC) MakeProcInstance((FARPROC)WndProc, hInstance);
	hWnd = CreateDialog(hInstance, szAppName, 0, dlgprc);

	ShowWindow(hWnd, nCmdShow);

	while (GetMessage(&msg, NULL, 0, 0)) {
		if (!TranslateAccelerator(hWnd, hAccel, &msg)) { 
			if (!IsDialogMessage(hWnd, &msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}

    // remember to free allocated memory
    XrtDestroy(hChart);
    
	return (int)msg.wParam;
}
